﻿using NVCC.Models;
using NVCC.WebUI.Infrastructure;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Web.ModelBinding;
using System.Web.Mvc;

namespace NVCC.WebUI.Models
{
    [Serializable]
    public class RoiAdminSearchViewModel
    {
       
        [Required(ErrorMessage = "Required")]
        public DateTime? StartDate { get; set; }

        
        [Required(ErrorMessage = "Required")]
        public DateTime? EndDate { get; set; }

        //[Display(Name = "VISN")]
        public string Visn { get; set; }

        //[Display(Name = "Facility")]
        public string FName { get; set; }

        [Required(ErrorMessage = "Required")]
        public short selectedVisnId { get; set; }
        public List<Visn> visnList { get; set; }

        public string selectedUserName { get; set; }
        public string selectedGivenName { get; set; }

        public List<UserByFacility> UserList { get; set; }

        //[Required(ErrorMessage = "Required")]
       
        public short facilityId { get; set; }
        public List<Facility> facilityList { get; set; }

        //[Required(ErrorMessage = "Required")]
        public string selectedFacilityName { get; set; }

        [Display(Name = "Please check the check box to show only Incomplete AOD list")]
        public bool incompleteAODChecked { get; set; }

        [Display(Name = "REFDOC User")]        
        public string userLabel { get; set; }

        public IEnumerable<ROIAdminSearch> roiAdminSearchList { get; set; }


        public static RoiAdminSearchViewModel retrieveFromSession()
        {
            const string roiAdminSessionKey = "RoiAdminSearch";
            if (HttpContextManager.Current.Session == null)
            {
                return null;
            }
            return HttpContextManager.Current.Session[roiAdminSessionKey] as RoiAdminSearchViewModel;
        }
    }
}